#include <iostream>
#include <vector>
using namespace std;

int calculateHappiness(const vector<int>& row1, const vector<int>& row2, int n) {
    int happiness = 0;
    int prev = row1[0]; 
    for (int i = 0; i < n; ++i) {
        if (i % 2 == 0) {
            if ((prev % 2) == (row2[i] % 2)) {
                ++happiness;
            }
            prev = row2[i];
        } else {
            if ((prev % 2) == (row1[i] % 2)) {
                ++happiness;
            }
            prev = row1[i];
        }
    }
    return happiness;
}

int maximizeHappiness(int n, vector<int>& row1, vector<int>& row2) {
    int maxHappiness = 0;

    for (int mask = 0; mask < (1 << n); ++mask) {
        vector<int> tempRow1 = row1;
        vector<int> tempRow2 = row2;

        for (int i = 0; i < n; ++i) {
            if (mask & (1 << i)) {
                swap(tempRow1[i], tempRow2[i]);
            }
        }

        maxHappiness = max(maxHappiness, calculateHappiness(tempRow1, tempRow2, n));
    }

    return maxHappiness;
}

int main() {
    int t;
    cin >> t;

    while (t--) {
        int n;
        cin >> n;

        vector<int> row1(n), row2(n);
        for (int i = 0; i < n; ++i) {
            cin >> row1[i];
        }
        for (int i = 0; i < n; ++i) {
            cin >> row2[i];
        }

        cout << maximizeHappiness(n, row1, row2) << endl;
    }

    return 0;
}